<?php

namespace Vote4Rewards\Pingback;

class LinkGenerator
{
    private string $baseUrl;

    /**
     * Create a new LinkGenerator instance
     *
     * @param string $baseUrl The base URL of vote4rewards.de (default: https://vote4rewards.de)
     */
    public function __construct(string $baseUrl = 'https://vote4rewards.de')
    {
        $this->baseUrl = rtrim($baseUrl, '/');
    }

    /**
     * Generate a vote link using server UUID (recommended)
     *
     * @param string $serverUuid The server UUID from vote4rewards.de
     * @param string $username The in-game username of the voter
     * @return string The complete vote URL
     */
    public function generateVoteLink(string $serverUuid, string $username): string
    {
        return $this->baseUrl . '/vote/' . urlencode($serverUuid) . '?rewarder=' . urlencode($username);
    }

    /**
     * Generate a vote link with custom query parameters
     *
     * @param string $serverUuid The server UUID from vote4rewards.de
     * @param array $params Additional query parameters (must include 'rewarder' key)
     * @return string The complete vote URL
     */
    public function generateVoteLinkWithParams(string $serverUuid, array $params): string
    {
        $url = $this->baseUrl . '/vote/' . urlencode($serverUuid);

        if (!empty($params)) {
            $url .= '?' . http_build_query($params);
        }

        return $url;
    }

    /**
     * @deprecated Use generateVoteLink() with UUID instead
     */
    public function generateVoteLinkBySlug(string $serverSlug, string $username): string
    {
        return $this->baseUrl . '/server/' . urlencode($serverSlug) . '?rewarder=' . urlencode($username);
    }
}
